@extends('layouts.site')
@section('meta_title', 'Catalog')

@section('content')

@include('partials._catalog.toolbar.buttons', ['class' => 'm-0'])

@if (isset($page) && $page->hasContent())
<div class="page-content white">
    <section class="container">
        <div class="row">
            <div class="col-md-12">
                {!! $page->getContent() !!}
            </div>
        </div>
    </section>
</div>
@endif
<div class="page-content">
    <section class="container">
        <div class="row text-center">
            @php $catalogCount = $catalogs->count(); @endphp
            @if ($catalogCount > 0)
                @foreach($catalogs as $catalog)
                <div class="mb-3 col-md-{{ 12 / $catalogCount }}">
                    <a style="display: block" class="panel" href="{{ route('catalog.show', ['catalog' => $catalog->code]) }}">
                        <h2 class="panel-title text-left p-3">{{ $catalog->name }}</h2>
                    </a>
                </div>
                @endforeach
            @else
                <div class="alert alert-danger">
                    Sorry, we don't support your country.
                </div>
            @endif
        </div>
    </section>
</div>

@endsection

@section('js')
@parent
@endsection