(function (jQuery, window, document, undefined) {
    'use strict';

    jQuery(document).ready(function ($) {
        var $body = $('body');
        var $pageHead = $('.page-head');
        var $pageNav = $('.page-nav');
        var $catalogNav = $('.navbar-catalog');

        // Affix the header to the top of the window
        $pageHead.affix({
            offset: {
                top: $pageHead.outerHeight()
            }
        }).on('affix.bs.affix', function () {
            var paddingTop = $pageHead.outerHeight();
            if ($catalogNav.length) {
                paddingTop = paddingTop + $catalogNav.outerHeight();
                setTimeout(function () {
                    $catalogNav
                        .addClass('affix')
                        .removeClass('affix-top')
                        .removeClass('affix-bottom')
                        .css('top', ($pageHead.outerHeight() - 2) + 'px');
                }, 200);
            }

            $body.css('padding-top', paddingTop);
        }).on('affixed-top.bs.affix', function () {
            $body.css('padding-top', 0);
            if ($catalogNav.length) {
                $catalogNav
                    .addClass('affix-top')
                    .removeClass('affix')
                    .removeClass('affix-bottom')
                    .css('top', 'auto');
            }
        });

        // In responsive mode, when you resize the window to desktop width, we
        // should make sure the navigation reverts back to normal desktop display.
        $(window).on('resize', function () {
            if (($(window).width() >= 992)) {
                $pageNav.removeClass('in');
                $('.page-nav-toggle').removeClass('active');
                $('body').css({'overflow': 'visible', 'position': 'static'});
            }
        });

        // In responsive mode, when you click on the menu toggle icon, it should animate
        $('.page-nav-toggle').on('click', function () {
            var $nav = $('.page-nav');
            $nav.toggleClass('in', !$nav.hasClass('in'));
            $(this).toggleClass('active', parseInt($nav.css('left')) !== 0);

            if ($('body').css('position') !== 'fixed' && ! $('#catalog-filters').hasClass('open')) {
                $('body').css({'overflow': 'hidden', 'position': 'fixed'});
            } else if ($('body').css('position') === 'fixed' && ! $('#catalog-filters').hasClass('open')) {
                $('body').css({'overflow': 'visible', 'position': 'static'});
            } else {
                // Not needed?
            }
        });

        // Wrap select elements
        (!$.fn.select2) && $('select.form-control').each(function () {
            var $this = $(this);
            var $wrap = $(document.createElement('span')).addClass('select-wrap').addClass('form-control');
            $this.wrap($wrap);
        });

        $('.item').matchHeight({
            byRow: true,
            property: 'height',
            target: null,
            remove: false
        });
    });
})(jQuery, window, document);
