var gulp = require('gulp');
var sass = require('gulp-sass');
var autoprefixer = require('gulp-autoprefixer');
var cleanCss = require('gulp-clean-css');
var imagemin = require('gulp-imagemin');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var run = require('gulp-run');

// Javascript
gulp.task('js', function() {
    return gulp.src([
        'node_modules/jquery/dist/jquery.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/affix.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/alert.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/button.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/collapse.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/dropdown.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/modal.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/tab.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/tooltip.js',
        'node_modules/bootstrap-sass/assets/javascripts/bootstrap/transition.js',
        //'node_modules/bootstrap-datepicker/dist/js/bootstrap-datepicker.js',
        'node_modules/jquery-match-height/dist/jquery.matchHeight.js',
        './src/js/script.js',
        //'node_modules/jquery-validation/dist/jquery.validate.js',
    ]).pipe(concat('script.js'))
      .pipe(uglify())
      .pipe(gulp.dest('./dist/javascripts'));
})

// SASS to CSS
gulp.task('css', function() {
    return gulp.src('./src/scss/style.scss')
        .pipe(sass({
            outputStyle: 'compressed',
            includePaths: [
                './src/scss',
                //'../../vendor/ignite/themes/default/src/scss',
                './node_modules/bootstrap-sass/assets/stylesheets'
            ]
        }).on('error', sass.logError))
        .pipe(autoprefixer({
            browsers: ['last 25 versions'],
            cascade: false
        }))
        .pipe(cleanCss({compatibility: 'ie9'}))
        .pipe(gulp.dest('./dist/stylesheets'));
});

// Fonts
gulp.task('fonts', function() {
    return gulp.src([
        'node_modules/font-awesome/fonts/*'])
        .pipe(gulp.dest('./dist/fonts'));
});

// Images
gulp.task('images', function(){
    return gulp.src('./dist/images/**/*.+(png|jpg|jpeg|gif|svg)')
        .pipe(imagemin({
            interlaced: true
        }))
        .pipe(gulp.dest('./dist/images'));
});

gulp.task('publish', function() {
    return run('php ../../artisan ignite:theme:publish').exec().pipe(gulp.dest('output'));
});

// Watcher
gulp.task('watch', function() {
    gulp.watch('dist/images/**/*.+(png|jpg|jpeg|gif|svg)', ['images']);
    gulp.watch('src/scss/**/*.scss', ['css']);
    gulp.watch('src/js/**/*.js', ['js']);
});

// Default compiler
gulp.task('default', ['js', 'css', 'fonts']);
