@extends('layouts.site')
@section('meta_title', 'Sign In to Your Account')
@section('content')

    <section class="container-centered">
        <div class="panel mt-5">
            <div class="panel-heading mt-4 mb-2 text-center">
                <span class="fa fa-lock fa-4x"></span>
                <h4 class="panel-title">Sign In to your Account</h4>
            </div>
            <div class="panel-body">
                <form class="form-classic" role="form" method="POST" action="{{ route('login') }}">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <label for="login-username" class="form-label">Login</label>
                        <input type="username" id="login-username" name="username" class="form-control form-control-has-validation" value="{{ old('username') }}" maxlength="255" required autofocus />
                        @if ($errors->has('username'))
                        <span class="help-block">
                              <strong>{{ $errors->first('username') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="login-password" class="form-label">Password</label>
                        <input type="password" id="login-password" name="password" class="form-control form-control-has-validation" value="" required />
                        @if ($errors->has('password'))
                        <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="login-remember" class="form-label"><input type="checkbox" name="remember" id="login-remember" /> Remember Me?</label>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                    @unless (empty($drivers = array_filter(config('core.auth.drivers', []))))
                        <p class="text-center m-1">OR</p>
                        @foreach ($drivers as $driver)
                        <a href="{{ route('sso.redirect', $driver) }}" class="btn btn-block btn-default">
                            <span class="text-primary">Sign in with {{ ucfirst($driver) }}</span>
                        </a>
                        @endforeach
                    @endunless
                    </div>
                </form>
            </div>
        </div>
    </section>
    <section class="container-centered">
        <div class="panel panel-transparent mt-2">
            <a href="{{ route('participant.enroll.create') }}" class="btn btn-block btn-default btn-tertiary">
                <span class="text-primary">Not enrolled yet? Enroll now.</span>
            </a>
            <a href="{{ route('password.request') }}" class="btn btn-block btn-default btn-tertiary">
                <span class="text-danger">Forgot your password? Reset it.</span>
            </a>
        </div>
    </section>

@endsection