@extends('layouts.site')

@section('meta_title', __('Catalog::order.front.heading'))

@section('content_header')
    @include('partials._components._heading', [
        'heading' => __('Catalog::order.front.heading'),
        'image' => false,
        'color' => 'blue'
    ])
@endsection

@section('content')
    @parent

    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="panel mt-4 mb-4">
                    <div class="panel-heading clearfix">
                        <h5 class="m-0 pt-2 pull-left">Order #{{ $order->number }}</h5>
                        <h5 class="m-0 pt-2 pull-right text-muted">Points: {{ Format::balance($order->points) }}</h5>
                    </div>
                    <div class="panel-body">
                        <div class="panel-fit clearfix">
                            <div class="panel-group p-0 m-0" id="accordion-items" role="tablist" aria-multiselectable="false">
                                <div class="panel panel-transparent p-0 m-0">
                                    <div class="panel-heading" role="tab" id="headingOrderItems">
                                        <h4 class="panel-title">
                                            <a href="#order-items" class="collapsible" role="button" data-toggle="collapse" data-parent="#accordion-items" aria-expanded="true" aria-controls="collapseOne">
                                                <span class="arrow"></span> Order Items
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="order-items" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOrderItems">
                                        <table class="table table-responsive" id="cartItemsTable">
                                            <thead>
                                            <tr>
                                                <th width="150" nowrap>&nbsp;</th>
                                                <th>Item Name</th>
                                                <th class="text-right">Qty</th>
                                                <th class="text-right">Points</th>
                                                <th class="text-right">Total</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @if ($order->items->isNotEmpty())
                                                @foreach($order->items as $item)
                                                    <tr>
                                                        <td width="150" style="max-width: 150px">
                                                            <a href="{{ route('catalog.item.show', $item->item->getKey()) }}" style="display: block;">
                                                                <img style="display: block;" class="item__image item__image--rounded img-responsive" src="{{ $item->getItemImageUrl()  }}">
                                                            </a>
                                                        </td>
                                                        <td>{{ $item->getItemName() }}</td>
                                                        <td class="text-right">{{ $item->getItemQuantity() }}</td>
                                                        <td class="text-right">{{ $item->getItemPoints() }}</td>
                                                        <td class="text-right">{{ $item->getItemTotal() }}</td>
                                                    </tr>
                                                @endforeach
                                                {{--<tr>
                                                    <td>&nbsp</td>
                                                    <td>&nbsp</td>
                                                    <td class="text-right"><b>Total:</b></td>
                                                    <td class="text-right"><b>{{ number_format($orderTotal) }}</b></td>
                                                    <td>&nbsp</td>
                                                </tr>--}}
                                            @else
                                                <tr>
                                                    <td colspan="4" class="text-danger text-center">There are no items in order.</td>
                                                </tr>
                                            @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-group p-0 m-0" id="accordion-details" role="tablist" aria-multiselectable="false">
                                <div class="panel panel-transparent p-0 m-0">
                                    <div class="panel-heading" role="tab" id="headingOrderDetails">
                                        <h4 class="panel-title">
                                            <a href="#order-details" class="collapsible" role="button" data-toggle="collapse" data-parent="#accordion-details" aria-expanded="false" aria-controls="collapseTwo">
                                                <span class="arrow"></span> Order Details
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="order-details" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOrderDetails">
                                        <div class="panel-body">
                                            <div class="form-classic form-horizontal mt-4">
                                                <div class="form-group">
                                                    <label for="ship_name" class="col-sm-4 control-label">Name</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_name" name="ship_name" value="{{ $order->ship_name ?? '' }}"  readonly />
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="ship_email" class="col-sm-4 control-label">Email</label>
                                                    <div class="col-sm-6">
                                                        <input type="email" class="form-control" id="ship_email" name="ship_email" value="{{ $order->ship_email ?? '' }}"  readonly />
                                                    </div>
                                                </div>

                                                <!--
                                                <div class="form-group">
                                                    <label for="last" class="col-sm-4control-label">Is this a business address?</label>
                                                    <input class="col-sm-6" type="checkbox" id="business" name="business" value="1" @if ( ! empty($order->business) )checked="checked"@endif readonly />
                                                </div>
                                                -->

                                                <div class="form-group">
                                                    <label for="ship_address_1" class="col-sm-4 control-label">Address - Line 1</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_address_1" name="ship_address_1" value="{{ $order->ship_address_1 ?? '' }}"  readonly />
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="ship_address_2" class="col-sm-4 control-label">Address - Line 2</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_address_2" name="ship_address_2" value="{{ $order->ship_address_2 ?? '' }}"  readonly />
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="ship_address_3" class="col-sm-4 control-label">Address - Line 3</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_address_3" name="ship_address_3" value="{{ $order->ship_address_3 ?? '' }}" readonly  />
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="ship_city" class="col-sm-4 control-label">City</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_city" name="ship_city" value="{{ $order->ship_city ?? '' }}"  readonly />
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="ship_state" class="col-sm-4 control-label">State</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_state" name="ship_state" value="{{ $order->ship_state ?? '' }}"  readonly />
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="ship_postal" class="col-sm-4 control-label">Zip/Postal Code</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_postal" name="ship_postal" value="{{ $order->ship_postal ?? '' }}"  readonly />
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="ship_country" class="col-sm-4 control-label">Country Code (ie: US)</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_country" name="ship_country" value="{{ $order->ship_country ?? 'US' }}"  readonly />
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="ship_phone" class="col-sm-4 control-label">Phone Number</label>
                                                    <div class="col-sm-6">
                                                        <input type="text" class="form-control" id="ship_phone" name="ship_phone" value="{{ $order->ship_phone ?? '' }}"  readonly />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
