@extends('layouts.site')

@section('meta_title', __('Catalog::theme.checkout.heading'))

@section('content')
    @include('partials._catalog.toolbar.toolbar')
    <section class="container">
        <div class="row">
            <div class="col-xs-12">
                @include('partials._catalog.toolbar.breadcrumbs', [
                    'crumbs' => [
                        ['url' => '', 'title' => __('Catalog::theme.checkout.heading')]
                    ],
                    'noCatalog' => true
                ])
            </div>
        </div>
        <div class="row">
            <div class="col-md-8">
                <div class="panel-stack-shadow">
                    <div class="panel panel-default panel-squared mb-4">
                        <div class="panel-body">
                            @include('partials._catalog.checkout.form', [
                                'cart' => $cart,
                                'participant' => auth()->user()->participant
                            ])
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-4">
                @include('partials._catalog.checkout.summary', ['cart' => $cart])
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script>

    </script>
@endsection
