@extends('layouts.site')

@section('meta_title', __('Catalog::theme.cart.heading'))

@section('content')
    @include('partials._catalog.toolbar.toolbar')
    <section class="container mt-2">
        <div class="row">
            <div class="col-xs-12">
                @include('partials._catalog.toolbar.breadcrumbs', [
                    'crumbs' => [
                        ['url' => '', 'title' => __('Catalog::theme.cart.heading')]
                    ],
                    'noCatalog' => true
                ])
            </div>
        </div>
        <div class="row">
            @if ($cart->notEmpty())
            <div class="col-xs-12">
                <div class="panel mb-4">
                    <div class="panel-body cart-panel">
                        <form id="cart" class="cart-form" name="cart" method="POST" action="{{ route('catalog.cart.update') }}">
                            {{ csrf_field() }}
                            {{ method_field('PUT') }}

                            @include('partials._catalog.cart.table', [
                                'cart' => $cart
                            ])
                        </form>
                        <div class="cart-buttons clearfix">
                            <a href="{{ route('catalog.index') }}" class="btn btn-default pull-left">{{ __('Catalog::theme.cart.continue') }}</a>
                        @if ($cart->canCheckout())
                            <a type="button" class="btn btn-success btn-lg pull-right" href="{{ route('catalog.checkout.create') }}">{{ __('Catalog::theme.cart.checkout') }}</a>
                        @endif
                        </div>
                    </div>
                </div>
            </div>
            @else
                <div class="col-sm-6 col-sm-offset-3 text-center">
                    <div class="text-center mt-4 mb-4">
                        <span class="fa fa-shopping-basket fa-5x text-muted muted"></span>
                        <h4 class="muted text-center">{{ __('Catalog::theme.cart.empty') }}</h4>
                    </div>
                    <a href="{{ route('catalog.index') }}" class="btn btn-default">{{ __('Catalog::theme.cart.continue') }}</a>
                </div>
            @endif
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script type="text/javascript" src="{{ asset('vendor/ignite/js/core/datatables.delete-entry.js') }}"></script>
    <script>
        $(document).ready(function() {
            $.deleteEntry({
                confirmation: '{{ __('Catalog::theme.cart.item.remove.confirm') }}',
                request: { method: 'DELETE', type: 'json' },
                data: function (button) {
                    return {
                        '_token': "{{ csrf_token() }}",
                        'item_id': $(button).data('itemId'),
                    };
                },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            window.location.reload();
                        });
                }
            });
            $('.update').click(function() {
                var $cart = $('form#cart');
                if ($cart.length) {
                    $cart.submit();
                }
            });
        });
    </script>
@endsection
