@extends('layouts.site')

@section('meta_title', $catalog->name)

@section('content')
    @include('partials._catalog.toolbar.buttons')
    <section class="container mt-2">
        @include('partials._catalog.breadcrumbs')
        <div class="row">
            <div class="col-xs-12 col-md-9 pull-right catalog-list">
                <div class="panel panel-transparent catalog-list-container">
                    <div class="panel-body p-0">
                        @if ($items->isNotEmpty())
                            <div class="row">
                                @foreach ($items as $item)
                                    <div class="col-xs-6 col-sm-4 col-md-4">
                                        @include('partials._catalog.item', $item)
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="col-sm-6 col-sm-offset-3 text-center">
                                <div class="text-center mt-4 mb-4">
                                    <span class="fa fa-shopping-basket fa-5x text-muted muted"></span>
                                    <h4 class="muted text-center">
                                    @if (request()->has('keyword'))
                                        Sorry no items found for search term "<strong>{{ request()->get('keyword') }}</strong>".
                                    @else
                                        Sorry no items found.
                                    @endif
                                    </h4>
                                </div>
                                @if (request()->has('keyword'))
                                    <a href="{{ route('catalog.show', $catalog->code) }}" class="btn btn-default">Reset Search</a>
                                @else
                                    <a href="{{ route('catalog.index') }}" class="btn btn-default">Back to Overview</a>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>
                {{ $items->appends(request()->input()) }}
            </div>
            <div class="col-md-3 pull-left catalog-filters" id="catalog-filters">
                @include('partials._catalog.sidebar')
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script src="{{ asset('/vendor/ignite/js/catalog/catalog.js') }}"></script>
@endsection
