<div class="row">
    <div class="{{ isset($breadcrumbClass) ? $breadcrumbClass : 'col-xs-8 col-sm-6' }}">
        <ol class="breadcrumb breadcrumb-transparent p-0">
            <li>
                <a href="{{ route('homepage') }}">
                    <span class="fa fa-home hidden-sm hidden-md hidden-lg"></span>
                    <span class="hidden-xs">Home</span>
                </a>
            </li>
            <li>
                <a href="{{ route('catalog.index') }}">
                    <span class="fa fa-trophy hidden-sm hidden-md hidden-lg"></span>
                    <span class="hidden-xs">Catalog</span>
                </a>
            </li>
            @if (session()->has('catalog') && !isset($noCatalog))
                <li><a href="{{ route('catalog.show', session('catalog.code')) }}">{{ session('catalog.name') }}</a></li>
            @endif
            @if (! empty($crumbs))
                @foreach ($crumbs as $crumb)
                    @if (empty($crumb['url']))
                        <li class="active">{{ $crumb['title'] }}</li>
                    @else
                        <li><a href="{{ $crumb['url'] }}">{{ $crumb['title'] }}</a></li>
                    @endif
                @endforeach
            @endif
        </ol>
    </div>
    @if (isset($items))
    <div class="col-xs-4 col-sm-6">
        <p class="text-right">
            <span class="hidden-xs">@if ($items->total() < $items->count()){{ $items->firstItem() }} to {{ $items->lastItem() }} of @endif</span>
            {{ $items->total() }} {{ str_plural('result', $items->total()) }}
            <span class="hidden-xs">@if (request()->get('keyword', '')) for &lsquo;{{ request()->get('keyword') }}&rsquo;@endif</span>
            <span class="hidden-xs">@if (session()->has('category'))in {{ session('category.name') }}@endif</span>
        </p>
    </div>
    @endif
</div>
