@component('mail::message')

Hello {{ $first_name }},

Your order, #{{ $order->number }}, will be processed shortly. Feel free to contact Rewards Program Headquarters with any questions at <a href="mailto:{{ config('mail.from.address') }}">{{ config('mail.from.address') }}</a>.

@if ($order->hasNonPhysical())
@component('mail::panel')
The eGift {{ str_plural('card', $order->countNonPhysical()) }} you ordered will be emailed within 24 hours to:
**{{ $order->ship_email }}**
@endcomponent
@endif
@if($order->hasPhysical())
@component('mail::panel')
Please allow 6-8 weeks for delivery.
@endcomponent

#### Shipping Information

@component('mail::panel')
- Name: {{ html_entity_decode($order->ship_name) }}
- Address 1: {{ $order->ship_address_1 }}
- Address 2: {{ $order->ship_address_2 }}
@if ($order->ship_address_3)- Address 3: {{ $order->ship_address_3 }}@endif
- City: {{ $order->ship_city }}
- State: {{ $order->ship_state }}
- Postal: {{ $order->ship_postal }}
- Country: {{ $order->ship_country }}
@endcomponent
@endif

@component('mail::table')
| Item              | Quantity              | Points              | Total               |
|:----------------- | ---------------------:| -------------------:| -------------------:|
@foreach ($order->items as $item)| {{ $item->name }} | {{ $item->quantity }} | {{ Format::amount($item->points) }} | {{ Format::amount($item->quantity * $item->points) }} |
@endforeach
| &nbsp; | &nbsp; | **Order Total** | **{{ Format::amount($order->points) }}** |
@endcomponent

@component('mail::button', ['url' => route('catalog.order.show', $order->number)])
View my Order
@endcomponent

Thanks,<br>
Reward Headquarters<br><br><small>{{ config('app.name') }}</small>
@endcomponent
