@extends('layouts.site')
@section('meta_title', __('Claim::claim.review.title'))
@section('content_header')
    @include('partials._components._heading', [
        'heading' => __('Claim::claim.review.title'),
        'image' => false,
        'color' => 'blue'
    ])
@endsection
@section('content')
    <section class="container">
        <div class="mt-4 mb-4">
            <div class="panel panel-default">
            @if(! empty($isAdminLayout))
                <div class="panel-heading">
                    <h3 style="margin: 0; padding-top: 5px;">{{ __('Core::core.fields.external') }}</h3>
                </div>
            @else
                <div class="panel-heading">
                    <div class="panel-title row">
                        <div class="col-md-6">
                            <strong style="margin: 0; padding-top: 5px;" class="align-middle">{{ __('Claim::claim.form_heading') }}</strong>
                        </div>
                    </div>
                </div>
            @endif
                <div class="panel-body">
                @include('Claim::partials.claimReviewFieldsExternal')
                </div>
            </div>

            @if ($formData['maxParticipants'] > 0)
                @include('Claim::partials.claimReviewParticipants_static')
            @endif

            @include('Claim::partials.claimReviewItems_static')

            @if (! empty($documentTypes))
              @include('Claim::partials.claimReviewFiles')
            @endif

            @include('partials._claim._review.buttons')
        </div>
    </section>
@endsection
