<div class="list-group">
    @foreach($cart->items() as $item)
        <div class="list-group-item media p-1">
            <div class="media-left">
                <a href="{{ $item->getItemUrl() }}">
                    <img style="max-width: 100px" class="img-responsive item__image--rounded" src="{{ $item->getItemImageUrl() }}" />
                </a>
            </div>
            <div class="media-body" style="width: auto;">
                <h5 class="media-heading mb-0">{{ $item->getItemName() }}</h5>
                <small class="muted">
                    Quantity: {{ $item->getItemQuantity() }}<br />
                    Points: {{ $item->getItemTotal() }}
                </small>
            </div>
        </div>
    @endforeach
</div>
<table class="clearfix table table-condensed">
    <tbody>
    <tr class="active">
        <td style="width: 75%;" class="text-right">Total:</td>
        <td class="text-right"><strong>{{ $cart->total() }}</strong></td>
    </tr>
    <tr>
        <td style="width: 75%;" class="text-right">Available:</td>
        <td class="text-right text-success"><strong>{{ $cart->balance() }}</strong></td>
    </tr>
    <tr>
        <td style="width: 75%;" class="text-right">After Order:</td>
        <td class="text-right text-danger"><strong>{{ $cart->deficit() }}</strong></td>
    </tr>
    </tbody>
</table>
