<table class="table table-responsive" id="cartItemsTable">
    <thead>
    <tr>
        <th class="hidden-xs" width="200">&nbsp;</th>
        <th class="text-muted"><span class="hidden-xs">Item</span> Name</th>
        <th class="text-muted text-right"><span class="visible-xs">Qty</span><span class="hidden-xs">Quantity</span></th>
        <th class="text-muted text-right">Points</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
    <tbody>
    @if ($cart->notEmpty())
        @foreach($cart->items() as $item)
            @include('partials._catalog.cart.item', [
                'item' => $item
            ])
        @endforeach
        <tr>
            <td class="hidden-xs">&nbsp;</td>
            <td>&nbsp;</td>
            <td class="text-right"><strong>Total:</strong></td>
            <td class="text-right"><strong>{{ $cart->total() }}</strong></td>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td class="hidden-xs">&nbsp;</td>
            <td>&nbsp;</td>
            <td class="text-right">Available:</td>
            <td class="text-right">{{ $cart->balance() }}</td>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td class="hidden-xs">&nbsp;</td>
            <td>&nbsp;</td>
            <td class="text-right">After Order:</td>
            <td class="text-right">
                @if ($cart->canCheckout())
                    {{ $cart->deficit() }}
                @else
                    <span class="text-danger">{{ $cart->deficit() }}</span>
                @endif
            </td>
            <td>&nbsp;</td>
        </tr>
    @else
        <tr>
            <td colspan="6" class="text-danger text-center">No items in cart.</td>
        </tr>
    @endif
    </tbody>
</table>
