@extends('layouts.site')

@section('meta_title', 'Enroll')

@section('content')

    <section class="container-centered-large">
        <div class="panel mt-4 mb-4">
            <div class="panel-heading">
                <div class="col-md-10 col-md-offset-1">
                    @if ($page->hasContent())
                        {!! $page->getContent() !!}
                    @else
                        <h2 class="text-center mb-4">Enroll</h2>
                    @endif
                </div>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" id="form_participant" role="form" method="post" action="{{ url('/register/confirm') }}">
                    {{ csrf_field() }}
                    <input type="hidden" name="code" value="{{ $code }}" />
                    @include('Participant::partials.participantFieldsExternal', [
                        'colClass' => 'col-xs-10 col-xs-offset-1 col-sm-12 col-sm-offset-0',
                        'dynamicFormLabelClass' => 'col-sm-4 text-left',
                        'dynamicFormControlClass' => 'col-sm-6'
                    ])
                    <hr/>
                    <div class="form-group text-center">
                        <button class="btn btn-primary mlr-auto" type="submit" id="reviewButton" name="reviewButton">Review</button>
                    </div>
                </form>
            </div>
        </div>
    </section>

@endsection

@section('js')
    @parent
    <script>
        jQuery(document).ready(function($) {
          var icons = {
            time: "fa fa-clock-o",
            date: "fa fa-calendar",
            up: "fa fa-arrow-up",
            down: "fa fa-arrow-down",
            previous: 'fa fa-chevron-left',
            next: 'fa fa-chevron-right',
            today: 'fa fa-calendar-times-o',
            clear: 'fa fa-trash',
            close: 'fa fa-remove'
          };

          $('.datetimepicker').datetimepicker({
            format: 'MM/DD/YYYY HH:mm:ss',
            icons: icons
          });

          $('.datepicker').datetimepicker({
            format: 'MM/DD/YYYY',
            icons: icons
          });

          $('#checkout').validate({
            errorElement: 'em',
            errorPlacement: function (error, element) {
              error.addClass('help-block');
              if (element.prop('type') === 'checkbox') {
                error.insertAfter(element.parent('label'));
              } else if (element.hasClass('select2')) {
                error.insertAfter(element.siblings('.select2-container'));
              } else {
                error.insertAfter(element);
              }
            },
            success: function (label, element) {},
            highlight: function (element, errorClass, validClass) {
              $(element).parents('.form-input').addClass('has-error');
            },
            unhighlight: function (element, errorClass, validClass) {
              $(element).parents('.form-input').removeClass('has-error');
            }
          });
        });
    </script>
@endsection
