@if ($menu && isset($menu->items))
<div class="panel panel-default panel-squared">
    <div class="panel-heading">
        <label class="m-0">Categories</label>
    </div>
    <div class="panel-body p-0">
        <ul class="nav nav-menu nav-stacked" id="menu">
        @foreach ($menu->items as $item)
            @if ($item->category->active)
            <li id="item-{{ $item->id }}" class="nav-menu-item {{ $item->category->id === session('category.id') ? 'active' : '' }}">
                <a class="nav-menu-link" href="{{ route('catalog.show', ['catalog' => $code, 'category' => $item->category->id]) }}">{{ $item->category->name }}{{-- ({{ $item->associated->count() }})--}}</a>
                @if ($item->children->isNotEmpty())
                    <a class="btn btn-link nav-menu-toggle" href="#menu-sub-{{ $item->id }}" data-toggle="collapse" data-parent="#item-{{ $item->id }}"><span class="caret"></span></a>
                @endif
                @if ($item->children->isNotEmpty())
                <ul class="nav nav-stacked collapse" id="menu-sub-{{ $item->id }}">
                    @foreach ($item->children as $child)
                    <li id="item-sub-{{ $item->id }}">
                        <a class="nav-menu-item-sub-link" href="{{ route('catalog.show', ['catalog' => $code, 'category' => $child->category->id]) }}">{{ $child->category->name }}</a>
                    </li>
                    @endforeach
                </ul>
                @endif
            </li>
            @endif
        @endforeach
        </ul>
    </div>
    @if (session()->has('category'))
        <input type="hidden" name="category" value="{{ request()->get('category', session('category.id', '')) }}">
    @endif
</div>
@endif
