@extends('layouts.site')
@section('meta_title', 'Promotions')
@section('content_header')
    @include('partials._components._heading', [
        'heading' => 'Promotions',
        'image' => false,
        'color' => 'blue'
    ])
@endsection
@section('content')
    <section class="container">
        <div class="panel mt-4 mb-4">
            @if (count($campaigns) > 1)
            <div class="panel-heading clearfix">
                <div class="btn-group">
                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        @if (empty($campaignId))
                        Choose Campaign
                        @else
                        Campaign: {{ collect($campaigns)->keyBy('id')->get($campaignId)['name'] }}
                        @endif
                        <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu">
                    @foreach($campaigns as $campaign)
                        <li class="{{ $campaign['id'] == "$campaignId" ? 'active' : '' }}"><a href="/claim/promotions/{{ $campaign['id'] }}">{{ $campaign['name'] }}</a></li>
                    @endforeach
                    </ul>
                </div>
            </div>
            @elseif (count($campaigns) == 1)
            @php ($campaign = reset($campaigns))
            <input type="hidden" name="campaignId" id="campaignId" value="{{ $campaign['id'] }}" />
            @else
            <input type="hidden" name="campaignId" id="campaignId" value="1" />
            @endif

            <div class="panel-body">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th class="hidden-xs hidden-sm">Description</th>
                                    <th class="hidden-xs">Start Date</th>
                                    <th class="hidden-xs">End Date</th>
                                    <th>Status</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                            @forelse($promotions as $promotion)
                                <tr data-promotion_id="{{ $promotion['id'] }}">
                                    <td class="offerDetails">{{ $promotion['id'] }}</td>
                                    <td class="offerDetails">{{ $promotion['name'] }}</td>
                                    <td class="offerDetails hidden-xs hidden-sm" title="Click for Offers Details.">{{ $promotion['description'] }}</td>
                                    <td class="offerDetails hidden-xs">{{ Format::date($promotion['start_date']) }}</td>
                                    <td class="offerDetails hidden-xs">{{ Format::date($promotion['end_date']) }}</td>
                                    <td class="offerDetails">{{ ($promotion['status'] == 1) ? 'active' : '' }}</td>
                                    <td>
                                        <a class="btn btn-sm btn-success pull-right" href="/claim/new/{{ $promotion['id'] }}">
                                            New Claim
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="text-center text-danger">No promotions available.</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
