<form id="checkout" name="checkout" method="post" action="{{ route('catalog.checkout.store') }}">
    {{ csrf_field() }}
    <div class="form-group">
        <div class="row">
            <div class="col-sm-4 form-input">
                <label for="first" class="control-label">First Name</label>
                <input type="text" class="form-control" id="first" name="first" value="{{ old('first', $participant->first) }}" maxLength="50" required />
            </div>
            <div class="col-sm-4 form-input">
                <label for="last" class="control-label">Last Name</label>
                <input type="text" class="form-control" id="last" name="last" value="{{ old('last', $participant->last) }}" maxLength="50" required />
            </div>
            <div class="col-sm-4 form-input">
                <label for="ship_phone" class="control-label">Phone Number</label>
                <input type="text" class="form-control" id="ship_phone" name="ship_phone" value="{{ old('ship_phone', $participant->phone1) }}" maxLength="20" required />
            </div>
        </div>
    </div>
    @if ($cart->hasNonPhysical())
        <hr class="clearfix" />
        <div class="form-group">
            <div class="row">
                <div class="col-sm-8 form-input">
                    <label for="email" class="control-label">Email</label>
                    <input type="email" class="form-control email" id="email" name="ship_email" value="{{ old('ship_email', $participant->email) }}" maxLength="255" required />
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <span class="help-block mb-0">
                        <em class="text-info">Please enter the email address to which you would like to send your {{ str_plural('card', $cart->countNonPhysical()) }}</em>.
                    </span>
                </div>
            </div>
        </div>
        <hr class="clearfix" />
    @endif
    @if ($cart->hasPhysical())
    <div class="form-group">
        <label for="ship_address_1" class="control-label">Address</label>
        <div class="row">
            <div class="col-sm-12 form-input">
                <input placeholder="Address 1" type="text" class="form-control" id="ship_address_1" name="ship_address_1" value="{{ old('ship_address_1', $participant->address_1) }}" maxLength="100" required />
            </div>
        </div>
        <div class="row mt-1">
            <div class="col-sm-6 form-input">
                <input placeholder="Address 2" type="text" class="form-control" id="ship_address_2" name="ship_address_2" value="{{ old('ship_address_2', $participant->address_2) }}" maxLength="100" />
            </div>
            <div class="col-sm-6 form-input">
                <input placeholder="Address 3" type="text" class="form-control" id="ship_address_3" name="ship_address_3" value="{{ old('ship_address_3', '') }}" maxLength="100" />
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-sm-4 form-input">
                <label for="ship_city" class="control-label">City</label>
                <input type="text" class="form-control" id="ship_city" name="ship_city" value="{{ old('ship_city', $participant->city) }}" maxLength="100" required />
            </div>
            <div class="col-sm-4 form-input">
                <label for="ship_state" class="control-label">State</label>
                @include('partials._forms._states',[
                    'name' => 'ship_state',
                    'state' => old('state', $participant->state),
                    'required' => true
                ])
            </div>
            <div class="col-sm-4 form-input">
                <label for="ship_postal" class="control-label">Zip/Postal Code</label>
                <input type="number" maxlength="5" class="form-control" id="ship_postal" name="ship_postal" value="{{ old('ship_postal', $participant->postal) }}" maxLength="20" required />
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-sm-12 form-input">
                <label>
                    <input type="checkbox" id="business" name="business" value="1"{{ !empty(old('business', '')) ? ' checked="checked"' : '' }} />
                    Is this a business address?
                </label>
            </div>
        </div>
    </div>
    <hr class="clearfix" />
    @endif
    {{--<div class="form-group">
        <label for="ship_country" class="col-sm-4 control-label">Country Code (ie: US)</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" id="ship_country" name="ship_country" value="{{ $order['ship_country'] ?? Auth::user()->participant->country ?? 'US' }}" maxLength="5" required />
        </div>
    </div>--}}
    <div class="form-group m-0">
        <a href="{{ route('catalog.index') }}" class="btn btn-default pull-left">Back to Cart</a>
        <button type="submit" class="btn btn-success pull-right">Place Order</button>
    </div>
</form>
