@extends('layouts.site')

@section('meta_title', 'Checkout')

@section('content')
    @include('partials._catalog.toolbar.buttons')
    <section class="container">
        <div class="row">
            <div class="col-xs-12">
                @include('partials._catalog.breadcrumbs', [
                    'crumbs' => [
                        ['url' => '', 'title' => 'Checkout']
                    ],
                    'noCatalog' => true
                ])
            </div>
        </div>
        <div class="row">
            <div class="col-md-8">
                <div class="panel-stack-shadow">
                    <div class="panel panel-default panel-squared mb-4">
                        <div class="panel-body">
                            @include('partials._catalog.checkout.form', [
                                'cart' => $cart,
                                'participant' => Auth::user()->participant
                            ])
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-4">
                @include('partials._catalog.checkout.summary', ['cart' => $cart])
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script>
        jQuery(document).ready(function($) {
            $('#checkout').validate({
                errorElement: 'em',
                errorPlacement: function (error, element) {
                    error.addClass('help-block');
                    if (element.prop('type') === 'checkbox') {
                        error.insertAfter(element.parent('label'));
                    } else if (element.hasClass('select2')) {
                        error.insertAfter(element.siblings('.select2-container'));
                    } else {
                        error.insertAfter(element);
                    }
                },
                success: function (label, element) {},
                highlight: function (element, errorClass, validClass) {
                    $(element).parents('.form-input').addClass('has-error');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).parents('.form-input').removeClass('has-error');
                }
            });
        });
    </script>
@endsection