<?php

namespace Ignite\Vendor\Tango\Response;

use Ignite\Vendor\Tango\ResponseException;
use Ignite\Vendor\Tango\Response\Response;
use Illuminate\Contracts\Support\Arrayable;
use Psr\Http\Message\ResponseInterface;

/**
 * Class OrderResponse
 *
 * @method string getReferenceOrderID()
 * @method string getExternalRefID()
 * @method string getCustomerIdentifier()
 * @method string getAccountIdentifier()
 * @method string getAccountNumber()
 * @method array  getAmountCharged()
 * @method array  getMarginShare()
 * @method array  getDenomination()
 * @method string getUtid()
 * @method string getRewardName()
 * @method array  getSender()
 * @method array  getRecipient()
 * @method string getSendEmail()
 * @method string getEtid()
 * @method string getStatus()
 * @method string getCreatedAt()
 * @method string getCampaign()
 * @method string getNotes()
 * @method array  getReward()
 */
class OrderResponse extends Response implements Arrayable
{
    /**
     * @var string
     */
    protected $referenceOrderID;

    /**
     * @var string
     */
    protected $externalRefID;

    /**
     * @var string
     */
    protected $customerIdentifier;

    /**
     * @var string
     */
    protected $accountIdentifier;

    /**
     * @var string
     */
    protected $accountNumber;

    /**
     * @var string
     */
    protected $amountCharged;

    /**
     * @var string
     */
    protected $marginShare;

    /**
     * @var string
     */
    protected $denomination;

    /**
     * @var string
     */
    protected $utid;

    /**
     * @var string
     */
    protected $rewardName;

    /**
     * @var string
     */
    protected $sender;

    /**
     * @var string
     */
    protected $recipient;

    /**
     * @var string
     */
    protected $emailSubject;

    /**
     * @var string
     */
    protected $message;

    /**
     * @var string
     */
    protected $sendEmail;

    /**
     * @var string
     */
    protected $etid;

    /**
     * @var string
     */
    protected $status;

    /**
     * @var string
     */
    protected $campaign;

    /**
     * @var string
     */
    protected $createdAt;

    /**
     * @var string
     */
    protected $notes;

    /**
     * @var string
     */
    protected $reward;

    /**
     * Create an instance from a Http Response.
     *
     * @param ResponseInterface $response
     * @return SubmitClosedLoopAnonymousResponse|static
     * @throws ResponseException
     */
    public static function fromHttpResponse(ResponseInterface $response)
    {
        $data = static::parseJson($response);

        $expected = [
            'referenceOrderID' => 'Reference Order ID',
            'externalRefID' => 'External Ref ID',
            'customerIdentifier' => 'Customer Identifier',
            'accountIdentifier' => 'Account Identifier',
            'accountNumber' => 'Account Number',
        ];
        foreach ($expected as $key => $name) {
            if (! isset($data[$key])) {
                throw new ResponseException($response, 'Expected ' . $name . ' in the response, unable to find the value using key `' . $key . '`.');
            }
        }

        if (! isset($data['status'])) {
            throw new ResponseException($response, 'Expected indication of success or failure in response, unable to find the value using key `status`.');
        }

        return app(static::class, $data)->setHttpResponse($response);
    }

    /**
     * Constructor
     *
     * @param string $referenceOrderID
     * @param string $externalRefID
     * @param string $customerIdentifier
     * @param string $accountIdentifier
     * @param string $accountNumber
     * @param array  $amountCharged
     * @param array  $marginShare
     * @param array  $denomination
     * @param string $utid
     * @param string $rewardName
     * @param array  $sender
     * @param array  $recipient
     * @param string $sendEmail
     * @param string $etid
     * @param string $status
     * @param string $createdAt
     * @param string $campaign
     * @param string $notes
     * @param array  $reward
     */
    public function __construct(
        string $referenceOrderID,
        string $externalRefID,
        string $customerIdentifier,
        string $accountIdentifier,
        string $accountNumber,
        array $amountCharged,
        array $marginShare,
        array $denomination,
        string $utid,
        string $rewardName,
        array $sender,
        array $recipient,
        string $sendEmail,
        string $etid,
        string $status,
        string $createdAt,
        string $campaign = null,
        string $notes = null,
        array $reward = []
    ) {
        $this->referenceOrderID = $referenceOrderID;
        $this->externalRefID = $externalRefID;
        $this->customerIdentifier = $customerIdentifier;
        $this->accountIdentifier = $accountIdentifier;
        $this->accountNumber = $accountNumber;
        $this->amountCharged = $amountCharged;
        $this->marginShare = $marginShare;
        $this->denomination = $denomination;
        $this->utid = $utid;
        $this->rewardName = $rewardName;
        $this->sender = $sender;
        $this->recipient = $recipient;
        $this->sendEmail = $sendEmail;
        $this->etid = $etid;
        $this->status = $status;
        $this->campaign = $campaign;
        $this->createdAt = $createdAt;
        $this->notes = $notes;
        $this->reward = $reward;
    }
}
