<?php

namespace Ignite\Vendor\Tango;

use Ignite\Vendor\Tango\Model;

class Sender extends Model
{
    /**
     * @var string
     */
    protected $firstName;

    /**
     * @var string
     */
    protected $lastName;

    /**
     * @var string
     */
    protected $email;

    /**
     * VirtualRecipient constructor.
     *
     * @param string $firstName
     * @param string $lastName
     * @param string $email
     */
    public function __construct(
        string $email,
        string $firstName = null,
        string $lastName = null
    ) {
        $this->guardAgainstInvalidEmail($email);

        $this->email = $email;
        $this->firstName = $firstName;
        $this->lastName = $lastName;
    }

    /**
     * Create a new instance from an associative array.
     *
     * @param  array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }
}
