<?php

namespace Ignite\Vendor\Tango;

use Psr\Http\Message\ResponseInterface;

class ResponseException extends \Exception
{
    /**
     * @var ResponseInterface
     */
    protected $response;

    /**
     * VendorResponseException constructor.
     *
     * @param ResponseInterface $response
     * @param string            $message
     * @param int               $code
     * @param \Throwable|null   $previous
     */
    public function __construct(ResponseInterface $response, $message, int $code = 0, \Throwable $previous = null)
    {
        $this->response = $response;

        $message = sprintf(
            'HTTP Response could not be converted%s (Status: %s - Reason: %s)',
            empty($message) ? '' : ': ' . $message,
            $response->getStatusCode(),
            $response->getReasonPhrase()
        );

        parent::__construct($message, $code, $previous);
    }
}
