<?php

namespace Ignite\Vendor\Tango\Request;

use Ignite\Vendor\Tango\Recipient;
use Ignite\Vendor\Tango\Request\Request;
use Ignite\Vendor\Tango\Sender;

class OrderRequest extends Request
{
    /**
     * @var string
     */
    protected $accountIdentifier;

    /**
     * @var string
     */
    protected $amount;

    /**
     * @var string
     */
    protected $campaign;

    /**
     * @var string
     */
    protected $customerIdentifier;

    /**
     * @var string
     */
    protected $emailSubject;

    /**
     * @var string
     */
    protected $etid;

    /**
     * @var string
     */
    protected $externalRefID;

    /**
     * @var string
     */
    protected $purchaseOrderNumber;

    /**
     * @var string
     */
    protected $message;

    /**
     * @var string
     */
    protected $notes;

    /**
     * @var string
     */
    protected $sendEmail;

    /**
     * @var string
     */
    protected $utid;

    /**
     * @var Recipient
     */
    protected $recipient;

    /**
     * @var Sender
     */
    protected $sender;

    /**
     * Create an instance from an associative array of data.
     *
     * @param  array $data
     * @return static
     */
    public static function fromAssociativeArray(array $data)
    {
        return app(static::class, $data);
    }

    /**
     * OrderRequest constructor.
     *
     * @param string $accountIdentifier
     * @param string $amount
     * @param string $campaign
     * @param string $customerIdentifier
     * @param string $emailSubject
     * @param string $etid
     * @param string $externalRefID
     * @param string $purchaseOrderNumber
     * @param string $message
     * @param string $notes
     * @param string $sendEmail
     * @param string $utid
     * @param array|Recipient $recipient
     * @param array|Sender $sender
     */
    public function __construct(
        string $accountIdentifier,
        string $amount,
        string $campaign = null,
        string $customerIdentifier,
        string $emailSubject = null,
        string $etid,
        string $externalRefID,
        string $purchaseOrderNumber,
        string $message = null,
        string $notes = null,
        string $sendEmail,
        string $utid,
        $recipient,
        $sender
    ) {
        $this->accountIdentifier = $accountIdentifier;
        $this->amount = $amount;
        $this->campaign = $campaign ?? null;
        $this->customerIdentifier = $customerIdentifier ?? null;
        $this->emailSubject = $emailSubject ?? null;
        $this->etid = $etid;
        $this->externalRefID = $externalRefID;
        $this->purchaseOrderNumber = $purchaseOrderNumber;
        $this->message = $message ?? null;
        $this->notes = $notes ?? null;
        $this->sendEmail = $sendEmail ?? null;
        $this->utid = $utid;
        $this->setRecipient($recipient);
        $this->setSender($sender);
    }

    /**
     * Set the recipient details.
     *
     * @param  array $recipient
     * @return $this
     */
    protected function setRecipient($recipient)
    {
        if (is_array($recipient) && ! empty($recipient)) {
            $recipient = app(Recipient::class, $recipient);
        }

        if (! $recipient instanceof Recipient) {
            throw new \InvalidArgumentException(
                "Invalid recipient, you must pass an instance of recipient or an array that can be converted."
            );
        }

        $this->recipient = $recipient;

        return $this;
    }

    /**
     * Set the sender details.
     *
     * @param  array $sender
     * @return $this
     */
    protected function setSender($sender)
    {
        if (is_array($sender) && ! empty($sender)) {
            $sender = app(Sender::class, $sender);
        }

        if (! $sender instanceof Sender) {
            throw new \InvalidArgumentException(
                "Invalid Sender, you must pass an instance of Sender or an array that can be converted."
            );
        }

        $this->sender = $sender;

        return $this;
    }
}
