<?php

namespace Ignite\Vendor\Tango\Response;

use Ignite\Vendor\Tango\ResponseException;
use Ignite\Vendor\Tango\Response\Response;
use Psr\Http\Message\ResponseInterface;

/**
 * Class ErrorResponse
 *
 * @method array getErrors()
 * @method bool hasErrors()
 * @method array getAdditionalInfo()
 * @method bool hasAdditionalInfo()
 */
class ErrorResponse extends Response implements ResponseInterface
{
    /** @var array */
    protected $errors;

    /**
     * Create an ErrorResponse object from a JSON HTTP response.
     *
     * @param  $response
     *
     * @return ErrorResponse
     * @throws ResponseException
     */
    public static function fromHttpResponse(ResponseInterface $response)
    {
        $data = static::parseJson($response);

        if (is_array($data) && ! array_key_exists('errors', $data)) {
            $data = ['errors' => $data];
        }

        if (! isset($data['errors'])) {
            throw new ResponseException($response, 'Expected errors in response, unable to locate using key `errors`.');
        }

        return app(static::class, $data)->setHttpResponse($response);
    }

    /**
     * ErrorResponse constructor.
     *
     * @param array $errors
     * @param array $additionalInfo
     */
    public function __construct(array $errors)
    {
        $this->errors = $errors;
    }
}
