<?php

namespace Ignite\StateMachine\Tests;

use Ignite\StateMachine\Contracts\StateInterface;
use Ignite\StateMachine\State;
use Ignite\StateMachine\Transition;

class StateTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_be_constructed_with_name_type_and_transitions()
    {
        $name = 'pending';
        $type = StateInterface::INITIAL;

        $state = new State($name, $type, []);

        $this->assertEquals($name, $state->name());
        $this->assertEquals($type, $state->type());
        $this->assertEmpty($state->transitions());
    }

    /**
     * @test
     */
    public function it_provides_a_helper_method_to_determine_initial_type()
    {
        $state = new State('foo', StateInterface::INITIAL, []);

        $this->assertEquals(StateInterface::INITIAL, $state->type());
    }

    /**
     * @test
     */
    public function it_provides_a_helper_method_to_determine_normal_type()
    {
        $state = new State('foo', StateInterface::NORMAL, []);

        $this->assertEquals(StateInterface::NORMAL, $state->type());
    }

    /**
     * @test
     */
    public function it_provides_a_helper_method_to_determine_final_type()
    {
        $state = new State('foo', StateInterface::FINAL, []);

        $this->assertEquals(StateInterface::FINAL, $state->type());
    }

    /**
     * @test
     */
    public function it_provides_a_method_to_add_transitions()
    {
        $state = new State('foo', StateInterface::INITIAL, []);

        $state->addTransition(new Transition('approving', ['submitted'], 'approved'));

        $this->assertContainsOnlyInstancesOf(Transition::class, $state->transitions());
    }
}
