<?php

namespace Ignite\StateMachine;

trait StatefulTrait
{
    /**
     * @var string
     */
    protected $state;

    /**
     * Set the state value.
     *
     * @param string $state
     */
    public function setState(string $state)
    {
        $this->state = $state;
    }

    /**
     * Get the state value.
     *
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }
}
