<?php

namespace Ignite\StateMachine\Tests;

use Ignite\StateMachine\Exceptions\StateNotFoundException;
use Ignite\StateMachine\State;

class StateNotFoundExceptionTest extends TestCase
{
    /**
     * @test
     */
    public function it_provides_a_useful_message()
    {
        $exception = new StateNotFoundException('foo', [
            'submitted' => new State('submitted', 'initial')
        ], $stateful = $this->getStatefulInstance());

        $className = get_class($stateful);

        $this->assertEquals("Unable to find state `foo` for `$className`", $exception->getMessage());

        $this->assertContainsOnlyInstancesOf(State::class, $exception->getStates());
        $this->assertEquals($stateful, $exception->getStatefulInstance());
        $this->assertEquals('foo', $exception->getName());
    }
}
