<?php

namespace Ignite\StateMachine\Contracts;

interface StateInterface
{
    const INITIAL = 'initial';
    const NORMAL = 'normal';
    const FINAL = 'final';

    /**
     * The state name representation.
     *
     * @return string
     */
    public function name();

    /**
     * The state type representation.
     *
     * @return string
     */
    public function type();

    /**
     * The available transitions for the current state.
     *
     * @return array
     */
    public function transitions();

    /**
     * Determine whether the type is initial.
     *
     * @return bool
     */
    public function isInitial();

    /**
     * Determine whether the type is normal.
     *
     * @return bool
     */
    public function isNormal();

    /**
     * Determine whether the type is final.
     *
     * @return bool
     */
    public function isFinal();
}
