<?php

namespace Ignite\StateMachine\Tests;

use Ignite\StateMachine\Contracts\StatefulInterface;
use Ignite\StateMachine\State;
use Ignite\StateMachine\StatefulTrait;
use Ignite\StateMachine\StateMachine;
use Ignite\StateMachine\Transition;
use Mockery;

class TransitionTest extends TestCase
{
    /**
     * @var Transition
     */
    protected $transition;

    /**
     * @inheritdoc
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->transition = new Transition('approve', ['submitted'], 'approved', function () {
            return false;
        });
    }

    /**
     * @test
     */
    public function it_can_provide_the_name_of_the_transition()
    {
        $this->assertEquals('approve', $this->transition->name());
    }

    /**
     * @test
     */
    public function it_can_provide_the_initial_states_allowed_to_transition_from()
    {
        $this->assertContains('submitted', $this->transition->initialStates());
    }

    /**
     * @test
     */
    public function it_can_provide_the_state_to_transition_to()
    {
        $this->assertEquals('approved', $this->transition->state());
    }

    /**
     * @test
     */
    public function it_can_provide_a_guard_to_check_whether_it_should_transition()
    {
        $callable = $this->transition->guard();

        $this->assertFalse($callable());
    }

    /**
     * @test
     */
    public function it_will_default_to_not_processing_anything_when_the_state_machine_runs_the_transition()
    {
        $states = [new State('submitted', 'initial'), new State('approved', 'final')];
        $transitions = [$this->transition];
        $stateMachine = $this->getStateMachine($states, $transitions);

        $this->assertNull($this->transition->process($stateMachine));
    }
}
