<?php

namespace Ignite\StateMachine\Exceptions;

use Exception;
use Ignite\StateMachine\Contracts\StatefulInterface;
use Throwable;

class StateNotFoundException extends Exception
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $states;

    /**
     * @var StatefulInterface
     */
    protected $stateful;

    /**
     * TransitionNotFoundException constructor.
     *
     * @param string $name
     * @param array $states
     * @param StatefulInterface $stateful
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct(
        string $name,
        array $states,
        StatefulInterface $stateful,
        $code = 0,
        Throwable $previous = null
    ) {
        $this->name = $name;
        $this->states = $states;
        $this->stateful = $stateful;

        parent::__construct($this->formatMessage(), $code, $previous);
    }

    /**
     * The formatted exception message.
     *
     * @return string
     */
    protected function formatMessage()
    {
        return sprintf(
            'Unable to find state `%s` for `%s`',
            $this->name,
            get_class($this->stateful)
        );
    }

    /**
     * Get the name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the states.
     *
     * @return array
     */
    public function getStates()
    {
        return $this->states;
    }

    /**
     * Get the stateful object instance.
     *
     * @return StatefulInterface
     */
    public function getStatefulInstance()
    {
        return $this->stateful;
    }
}
