<?php

namespace Ignite\StateMachine\Tests;

use Ignite\StateMachine\Contracts\StatefulInterface;
use Ignite\StateMachine\StatefulTrait;
use Ignite\StateMachine\StateMachine;
use Ignite\StateMachine\Tests\Stubs\Stateful;
use Mockery;

class TestCase extends \PHPUnit\Framework\TestCase
{
    /**
     * An instance of the stateful interface.
     *
     * @return StatefulInterface
     */
    protected function getStatefulInstance()
    {
        return new Stateful;
    }

    /**
     * An instance of the state machine.
     *
     * @param array $states
     * @param array $transitions
     *
     * @return StateMachine
     */
    protected function getStateMachine(array $states, array $transitions)
    {
        $dispatcher = Mockery::spy('Illuminate\Contracts\Events\Dispatcher');

        return new StateMachine(
            $this->getStatefulInstance(), $states, $transitions, $dispatcher
        );
    }

    /**
     * @inheritdoc
     */
    protected function tearDown(): void
    {
        Mockery::close();
    }
}
