<?php

namespace Ignite\StateMachine\Tests;

use Ignite\StateMachine\Contracts\StateInterface;
use Ignite\StateMachine\Contracts\StateMachineInterface;
use Ignite\StateMachine\Factory;
use Mockery;

class FactoryTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_create_a_state_machine_and_assign_transitions_to_each_of_the_registered_states()
    {
        $stateful = $this->getStatefulInstance();

        $states = [
            'submitted' => [
                'type' => StateInterface::INITIAL,
            ],
            'declined' => [
                'type' => StateInterface::FINAL,
            ],
            'approved' => [
                'type' => StateInterface::NORMAL,
            ],
            'issued' => [
                'type' => StateInterface::FINAL,
            ]
        ];

        $transitions = [
            'approve' => [
                'from' => ['submitted'],
                'to' => 'approved',
            ],
            'decline' => [
                'from' => ['submitted'],
                'to' => 'declined',
            ],
            'issue' => [
                'from' => ['approved'],
                'to' => 'issued',
            ],
            'cancel' => [
                'from' => ['issued'],
                'to' => 'declined',
            ]
        ];

        $dispatcher = Mockery::mock('Illuminate\Contracts\Events\Dispatcher');

        $stateMachine = (new Factory($states, $transitions, $dispatcher))->create($stateful);

        $this->assertInstanceOf(StateMachineInterface::class, $stateMachine);

        $submittedTransitions = $stateMachine->getState('submitted')->transitions();
        $this->assertArrayHasKey('approve', $submittedTransitions);
        $this->assertArrayHasKey('decline', $submittedTransitions);

        $this->assertEmpty($stateMachine->getState('declined')->transitions());

        $approvedTransitions = $stateMachine->getState('approved')->transitions();
        $this->assertArrayHasKey('issue', $approvedTransitions);

        $approvedTransitions = $stateMachine->getState('issued')->transitions();
        $this->assertArrayHasKey('cancel', $approvedTransitions);
    }
}
