<?php

namespace Ignite\StateMachine\Tests;

use Ignite\StateMachine\Exceptions\TransitionNotFoundException;
use Ignite\StateMachine\Transition;

class TransitionNotFoundExceptionTest extends TestCase
{
    /**
     * @test
     */
    public function it_provides_a_useful_message()
    {
        $exception = new TransitionNotFoundException('foo', [
            'approve' => new Transition('approve', ['submitted'], 'approve')
        ], $stateful = $this->getStatefulInstance());

        $className = get_class($stateful);

        $this->assertEquals("Unable to find transition `foo` for `$className`", $exception->getMessage());

        $this->assertContainsOnlyInstancesOf(Transition::class, $exception->getTransitions());
        $this->assertEquals($stateful, $exception->getStatefulInstance());
        $this->assertEquals('foo', $exception->getName());
    }
}
