<?php

namespace Ignite\StateMachine\Tests;

use Ignite\StateMachine\Exceptions\TransitionNotAllowedException;
use Ignite\StateMachine\State;
use Ignite\StateMachine\Transition;

class TransitionNotAllowedExceptionTest extends TestCase
{
    /**
     * @test
     */
    public function it_provides_a_useful_message()
    {
        // Notice: Transitions array is empty for 'submitted' state so it will not be allowed to transition to approved
        $exception = new TransitionNotAllowedException(
            $transition = new Transition('approve', ['submitted'], 'approved'),
            $state = new State('submitted', 'initial', []),
            $stateful = $this->getStatefulInstance()
        );

        $className = get_class($stateful);

        $this->assertEquals("Cannot transition $className from `submitted` to `approved`", $exception->getMessage());

        $this->assertEquals($transition, $exception->getTransition());
        $this->assertEquals($state, $exception->getState());
        $this->assertEquals($stateful, $exception->getStatefulInstance());
    }
}
