<?php

namespace Ignite\StateMachine\Exceptions;

use Exception;
use Ignite\StateMachine\Contracts\StatefulInterface;
use Throwable;

class TransitionNotFoundException extends Exception
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $transitions;

    /**
     * @var StatefulInterface
     */
    protected $stateful;

    /**
     * TransitionNotFoundException constructor.
     *
     * @param string $name
     * @param array $transitions
     * @param StatefulInterface $stateful
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct(
        string $name,
        array $transitions,
        StatefulInterface $stateful,
        $code = 0,
        Throwable $previous = null
    ) {
        $this->name = $name;
        $this->transitions = $transitions;
        $this->stateful = $stateful;

        parent::__construct($this->formatMessage(), $code, $previous);
    }

    /**
     * The formatted exception message.
     *
     * @return string
     */
    protected function formatMessage()
    {
        return sprintf(
            'Unable to find a transition to `%s` from `%s` for `%s`',
            $this->name,
            $this->stateful->getState(),
            get_class($this->stateful)
        );
    }

    /**
     * Get the name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the transitions.
     *
     * @return array
     */
    public function getTransitions()
    {
        return $this->transitions;
    }

    /**
     * Get the stateful object instance.
     *
     * @return StatefulInterface
     */
    public function getStatefulInstance()
    {
        return $this->stateful;
    }
}
