<?php

namespace Ignite\StateMachine\Contracts;

interface TransitionInterface
{
    /**
     * The transition name representation.
     *
     * @return string
     */
    public function name();

    /**
     * The transition name representation.
     *
     * @return string
     */
    public function label();

    /**
     * The array of states supported by this transition.
     *
     * @return array
     */
    public function initialStates();

    /**
     * Returns the state after processing the transition.
     *
     * @return string
     */
    public function state();

    /**
     * When the closure execution returns false, the transition cannot be applied.
     *
     * @return callable
     */
    public function guard();

    /**
     * Process the transition.
     *
     * @param StateMachineInterface $stateMachine
     *
     * @return mixed
     */
    public function process(StateMachineInterface $stateMachine);
}
