<?php

namespace Ignite\StateMachine\Contracts;

interface StatefulInterface
{
    /**
     * Set the value of the simple reference to the state representation for storage.
     *
     * @param string $state
     *
     * @return void|self
     */
    public function setState(string $state);

    /**
     * The simple reference to the state representation from storage.
     *
     * @return string
     */
    public function getState();
}
