<?php

namespace Ignite\StateMachine;

use Ignite\StateMachine\Contracts\StateMachineInterface;
use Ignite\StateMachine\Contracts\TransitionInterface;

class Transition implements TransitionInterface
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $initialStates;

    /**
     * @var string
     */
    protected $state;

    /**
     * @var callable|null
     */
    protected $guard;

    /**
     * Transition constructor.
     *
     * @param string $name
     * @param array $initialStates
     * @param string $state
     * @param callable|null $guard
     */
    public function __construct(string $name, array $initialStates, string $state, callable $guard = null)
    {
        $this->name = $name;
        $this->state = $state;
        $this->initialStates = $initialStates;
        $this->guard = $guard;
    }

    /**
     * @inheritDoc
     */
    public function name()
    {
        return $this->name;
    }

    /**
     * @inheritDoc
     */
    public function label()
    {
        return ucwords(str_replace('_', ' ', $this->name));
    }

    /**
     * @inheritDoc
     */
    public function state()
    {
        return $this->state;
    }

    /**
     * @inheritDoc
     */
    public function initialStates()
    {
        return $this->initialStates;
    }

    /**
     * @inheritDoc
     */
    public function guard()
    {
        return $this->guard;
    }

    /**
     * @inheritDoc
     */
    public function process(StateMachineInterface $stateMachine)
    {
        return;
    }
}
