<?php

namespace Ignite\Packages\Presenter\Stubs;

use Illuminate\Database\Eloquent\Model;
use Ignite\Packages\Presenter\Contracts\Presenter;
use Ignite\Packages\Presenter\Traits\Presentable;

class DecoratedModelStub extends Model implements Presenter
{
    /**
     * Use the presentable trait in order to get access to the present() method.
     */
    use Presentable;

    /**
     * Set a fake table name, we wont be accessing a database in our test.
     * @var string
     */
    protected $table = 'stubs';

    /**
     * Remove all mass-assignment guards for our test.
     * @var array
     */
    protected $guarded = [];

    /**
     * Set the presenter class path.
     * @var string
     */
    protected $presenter = ModelPresenterStub::class;
}
