<?php

use Ignite\Packages\Presenter\Stubs\DecoratedModelStub;
use Ignite\Packages\Presenter\Stubs\ModelPresenterStub;
use Ignite\Packages\Presenter\Stubs\MissingPresenterModelStub;

class PresenterTest extends \Orchestra\Testbench\TestCase
{
    /**
     * @test
     */
    public function itReturnsTheExpectedPresenterInstance()
    {
        $decoratedModel = new DecoratedModelStub();

        $this->assertInstanceOf(ModelPresenterStub::class, $decoratedModel->present());
    }

    /**
     * @test
     */
    public function itCanAccessPropertyOnModelViaMethodOnPresenter()
    {
        $decoratedModel = new DecoratedModelStub(['foo' => 'foo']);

        $this->assertEquals('foo', $decoratedModel->present()->foo());
    }

    /**
     * @test
     */
    public function itCanAccessMethodOnPresenter()
    {
        $decoratedModel = new DecoratedModelStub(['foo' => 'foo']);

        $this->assertEquals('foo bar', $decoratedModel->present()->fooBar());
    }

    /**
     * @test
     */
    public function itCannotCallMethodOnModelViaPresenter()
    {
        $decoratedModel = new DecoratedModelStub(['foo' => 'foo']);

        $this->assertNull($decoratedModel->present()->save());
    }

    /**
     * @test
     */
    public function itCanAccessMethodOnPresenterAndPassParameters()
    {
        $decoratedModel = new DecoratedModelStub(['foo' => 'foo']);

        $this->assertEquals('foo bar baz', $decoratedModel->present()->parameters('bar', 'baz'));
    }

    /**
     * @test
     * @expectedException \Ignite\Packages\Presenter\Exceptions\PresenterException
     */
    public function itWillThrowAnExceptionWhenNoPresenterHasBeenSpecified()
    {
        $undecoratedModel = new MissingPresenterModelStub(['foo' => 'foo']);

        $undecoratedModel->present();
    }

    /**
     * @test
     */
    public function itWillNormalizeCamelCaseToSnakeCase()
    {
        $decoratedModel = new DecoratedModelStub(['foo_bar_baz' => 'value']);

        $this->assertEquals('value', $decoratedModel->present()->fooBarBaz());
    }
}
