# Ignite Presenter

## Installation

Install via composer:

```json
{
  "require": {
    "ignite/presenter": "^1.0"
  },
  "repositories": {
    "presenter": {
      "type": "git",
      "url": "git@bitbucket.org:brightspot-packages/presenter.git"
    }
  }
}
```

## Usage:

Create a presenter class that will map to your eloquent model. These will be simple objects that do nothing more than format data in a readable way.

Here's an example of a presenter class.

```php
<?php

use Ignite\Packages\Presenter\Presenter;

class UserPresenter extends Presenter
{
    public function fullName()
    {
        return $this->first . ' ' . $this->last;
    }

    public function accountAge()
    {
        return $this->created_at->diffForHumans();
    }
}
```

Next, on your eloquent model, pull in the `Ignite\Packages\Presenter\Traits\Presentable` trait, which will automatically hook up your presenter class.

```php
<?php

namespace Ignite\Modules\Core\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Packages\Presenter\Contracts\Presenter;
use Ignite\Packages\Presenter\Traits\Presentable;

class User extends Model implements Presenter
{
    use Presentable;

    protected $presenter = \Ignite\Modules\Core\Presenters\User::class;

}
```

That's it! You're done. Now, within your view, you can use it like so:

```blade
<h1>Hello, {{ $user->present()->fullName() }}</h1>
```

