<?php

namespace Ignite\Packages\Presenter\Stubs;

use Ignite\Packages\Presenter\Presenter;

class ModelPresenterStub extends Presenter
{
    /**
     * Method accepts no parameters and calls underlying property on the entity.
     *
     * @return string
     */
    public function fooBar()
    {
        return $this->entity->foo . ' bar';
    }

    /**
     * Method accepts parameters at call-time.
     *
     * @param  string $foo
     * @param  string $bar
     * @return string
     */
    public function parameters($foo, $bar)
    {
        return $this->entity->foo . ' ' . (string) $foo . ' ' . (string) $bar;
    }
}
