<?php

namespace Ignite\Packages\Presenter\Stubs;

use Ignite\Packages\Presenter\Contracts\Presenter;
use Ignite\Packages\Presenter\Traits\Presentable;
use Illuminate\Database\Eloquent\Model;

class MissingPresenterModelStub extends Model implements Presenter
{
    /**
     * Use the presentable trait in order to get access to the present() method.
     */
    use Presentable;

    /**
     * Set a fake table name, we wont be accessing a database in our test.
     * @var string
     */
    protected $table = 'stubs';

    /**
     * Remove all mass-assignment guards for our test.
     * @var array
     */
    protected $guarded = [];

    // Note: We are purposefully not setting the $presenter property in order to test we get the expected exception.
}
