<?php

namespace Ignite\Packages\Presenter\Traits;

use Ignite\Packages\Presenter\Exceptions\PresenterException;

trait Presentable
{
    /**
     * View presenter instance.
     * @var \Ignite\Packages\Presenter\Contracts\Presenter
     */
    protected $presenterInstance;

    /**
     * Prepare a new or cached presenter instance.
     *
     * @return \Ignite\Packages\Presenter\Contracts\Presenter
     * @throws PresenterException
     */
    public function present()
    {
        if ( ! $this->presenter || ! class_exists($this->presenter)) {
            throw new PresenterException('Please set the $presenter property to your presenter path.');
        }

        if ( ! $this->presenterInstance) {
            $this->presenterInstance = app($this->presenter, ['entity' => $this]);
        }

        return $this->presenterInstance;
    }
}
