<?php

namespace Ignite\Packages\Presenter;

use Illuminate\Support\Str;

abstract class Presenter
{
    /**
     * The eloquent entity.
     *
     * @var \Illuminate\Database\Eloquent\Model
     */
    protected $entity;

    /**
     * Create a new presenter instance.
     *
     * @param \Illuminate\Database\Eloquent\Model $entity
     */
    public function __construct($entity)
    {
        $this->entity = $entity;
    }

    /**
     * Allow for property retrieval via camelCase method.
     *
     * @param  string $name
     * @param  array $parameters
     * @return mixed
     */
    public function __call($name, $parameters)
    {
        return $this->entity->getAttributeValue(Str::snake($name));
    }
}
