<?php

namespace Ignite\Extensions\Monolog\Tests\Parser;

use Carbon\Carbon;
use DateTime;
use Ignite\Extensions\Monolog\Parser\LineLogParser;
use PHPUnit\Framework\TestCase;

class LineLogParserTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_parse_a_log_line()
    {
        $parser = new LineLogParser();

        // General Test
        $log = $parser->parse('[2013-03-16 14:19:51] test.INFO: foobar {"foo":"bar"} []');
        $this->assertInstanceOf(DateTime::class, $log['date']);
        $this->assertInstanceOf(Carbon::class, $log['date']);
        $this->assertEquals('test', $log['logger']);
        $this->assertEquals('INFO', $log['level']);
        $this->assertEquals('foobar', $log['message']);
        $this->assertArrayHasKey('foo', $log['context']);

        // Test from Ignite
        $log = $parser->parse('[2020-02-19T16:54:53.864913+00:00] import.ERROR: Rejected line `1` with type `EARNED` for participant identified by email `73326` with transaction value `50` - Error: Participant with identifier `73326` is not enrolled {"user_id":"73326","value":"50","type":"EARNED"} []');
        $this->assertInstanceOf(Carbon::class, $log['date']);
        $this->assertEquals('import', $log['logger']);
        $this->assertEquals('ERROR', $log['level']);
        $this->assertEquals('Rejected line `1` with type `EARNED` for participant identified by email `73326` with transaction value `50` - Error: Participant with identifier `73326` is not enrolled', $log['message']);
        $this->assertEquals(["user_id" => "73326", "value" => "50", "type" => "EARNED"], $log['context']);
        $this->assertEmpty($log['extra']);
    }
}
