<?php

namespace Ignite\Extensions\Monolog\Reader;

use Ignite\Extensions\Monolog\Parser\LineLogParser;

class AbstractReader
{
    /**
     * The default regular expression pattern.
     *
     * @var string
     */
    protected $defaultParserPattern;

    /**
     * Create a new instance of the reader.
     *
     * @param string $defaultParserPattern
     */
    public function __construct($defaultParserPattern)
    {
        $this->defaultParserPattern = $defaultParserPattern;
    }

    /**
     * The instance of the default parser.
     *
     * @return LineLogParser
     */
    protected function getDefaultParser()
    {
        return new LineLogParser($this->defaultParserPattern);
    }
}
