Line Parser
==============
A simple extension for parsing [monolog](https://github.com/Seldaek/monolog) log files.

## Installation

You can install the library using [composer]('http://getcomposer.org/) by adding `ignite/line-parser` to your `composer.json`.

```json
{
  "require": {
    "ignite/line-parser": "^1.0"
  },
  "repositories": {
    "satis": {
      "type": "composer",
      "url": "https://satis.brightspot.work"
    }
  }
}
```

## Usage

```php
use Ignite\Extensions\Monolog\Reader\LogReader;
    
$logFile = '/path/to/some/monolog.log';
$reader = new LogReader($logFile);
   
foreach ($reader as $log) {
    echo sprintf("The log entry was written at %s. \n", $log['date']->format('Y-m-d h:i:s'));
}
    
$lastLine = $reader[count($reader) - 1];
echo sprintf("The last log entry was written at %s. \n", $lastLine['date']->format('Y-m-d h:i:s'));
```
