<?php

namespace Ignite\Extensions\Monolog\Tests\Reader;

use Ignite\Extensions\Monolog\Reader\LogReader;
use PHPUnit\Framework\TestCase;
use RuntimeException;

class LogReaderTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_read_and_parse_a_log_file()
    {
        $file = __DIR__ . '/../fixtures/test.log';
        $reader = new LogReader($file);

        $log = $reader[0];

        $this->assertInstanceOf('\DateTime', $log['date']);
        $this->assertEquals('test', $log['logger']);
        $this->assertEquals('INFO', $log['level']);
        $this->assertEquals('foobar', $log['message']);
        $this->assertArrayHasKey('foo', $log['context']);

        $log = $reader[1];

        $this->assertInstanceOf('\DateTime', $log['date']);
        $this->assertEquals('aha', $log['logger']);
        $this->assertEquals('DEBUG', $log['level']);
        $this->assertEquals('foobar', $log['message']);
        $this->assertArrayNotHasKey('foo', $log['context']);

    }

    /**
     * @test
     */
    public function it_can_iterate_over_a_log_file()
    {
        // the test.log file contains 2 log lines
        $file = __DIR__ . '/../fixtures/test.log';
        $reader = new LogReader($file);
        $lines = array();
        $keys = array();

        $this->assertTrue($reader->offsetExists(0));
        $this->assertTrue($reader->offsetExists(1));

        $this->assertFalse($reader->offsetExists(2));
        $this->assertFalse($reader->offsetExists(3));

        $this->assertEquals(2, count($reader));

        foreach ($reader as $i => $log) {
            $test = $reader[0];
            $lines[] = $log;
            $keys[] = $i;
        }

        $this->assertEquals(array(0, 1), $keys);
        $this->assertEquals('test', $lines[0]['logger']);
        $this->assertEquals('aha', $lines[1]['logger']);

    }

    /**
     * @test
     */
    public function it_throws_an_exception_when_attempting_to_set_the_value_of_an_offset_key()
    {
        $this->expectException(RuntimeException::class);
        $file = __DIR__ . '/../fixtures/test.log';
        $reader = new LogReader($file);
        $reader[5] = 'foo';
    }
}
