<?php

namespace Ignite\Extensions\Monolog\Tests\Parser;

use DateTime;
use Ignite\Extensions\Monolog\Parser\LineLogParser;
use PHPUnit\Framework\TestCase;

class LineLogParserTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_parse_a_log_line()
    {
        $parser = new LineLogParser();
        $log = $parser->parse('[2013-03-16 14:19:51] test.INFO: foobar {"foo":"bar"} []');

        $this->assertInstanceOf(DateTime::class, $log['date']);
        $this->assertEquals('test', $log['logger']);
        $this->assertEquals('INFO', $log['level']);
        $this->assertEquals('foobar', $log['message']);
        $this->assertArrayHasKey('foo', $log['context']);
    }
}
