<?php

namespace Ignite\HelixCatalog\Listeners;

use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Auth\Events\Registered;

class SyncOnRegister extends Sync
{
    /**
     * Handle the event.
     *
     * @param Registered $event
     *
     * @return void
     * @throws GuzzleException
     */
    public function handle(Registered $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        $this->session->handle($this->request, $this->user($event->user));
    }
}
